package applet;

import java.awt.event.MouseAdapter;

import javax.swing.JComponent;
import javax.swing.RootPaneContainer;

/** Basic CursorToolkit that still allows mouse clicks */
public class CursorToolkitOne implements Cursors {
	private CursorToolkitOne() {
	}

	private final static MouseAdapter mouseAdapter = new MouseAdapter() {
	};

	/** Sets cursor for specified component to Wait cursor */
	public static void startWaitCursor(JComponent component) {
		RootPaneContainer root = ((RootPaneContainer) component
				.getTopLevelAncestor());
		root.getGlassPane().setCursor(WAIT_CURSOR);
		root.getGlassPane().addMouseListener(mouseAdapter);
		root.getGlassPane().setVisible(true);
	}

	/** Sets cursor for specified component to normal cursor */
	public static void stopWaitCursor(JComponent component) {
		RootPaneContainer root = ((RootPaneContainer) component
				.getTopLevelAncestor());
		root.getGlassPane().setCursor(DEFAULT_CURSOR);
		root.getGlassPane().removeMouseListener(mouseAdapter);
		root.getGlassPane().setVisible(false);
	}

}